//
//  YYNavigationViewController.m
//  YYObjCDemo
//
//  Created by zhaoxiangru on 2021/2/3.
//  Copyright © 2021 百度鹰眼. All rights reserved.
//

#import "YYNavigationViewController.h"

@interface YYNavigationViewController ()

@end

@implementation YYNavigationViewController

- (instancetype)initWithRootViewController:(UIViewController *)rootViewController {
    if (self = [super initWithRootViewController:rootViewController]) {
        NSDictionary *titleTextAttributes = @{ NSForegroundColorAttributeName:[UIColor whiteColor]};
        if (@available(iOS 13.0, *)) {
            UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
            //导航栏颜色
            appearance.backgroundColor = [UIColor colorWithRed:34 / 255.0 green:37 / 255.0 blue:61 / 255.0 alpha:0.9];
            //导航栏字体颜色
            appearance.titleTextAttributes = titleTextAttributes;
            //隐藏导航返回按钮文字
            UIBarButtonItemAppearance *barButtonItemAppearance = [UIBarButtonItemAppearance new];
            barButtonItemAppearance.normal.titlePositionAdjustment = UIOffsetMake(-1000, 0);
            appearance.backButtonAppearance = barButtonItemAppearance;
            self.navigationBar.standardAppearance = appearance;
            self.navigationBar.scrollEdgeAppearance = appearance;
        } else {
            //导航栏颜色
            self.navigationBar.barTintColor = [UIColor colorWithRed:34 / 255.0 green:37 / 255.0 blue:61 / 255.0 alpha:0.9];
            //导航栏字体颜色
            [[UINavigationBar appearance] setTitleTextAttributes:titleTextAttributes];
            //隐藏导航返回按钮文字
            [[UIBarButtonItem appearance] setBackButtonTitlePositionAdjustment:UIOffsetMake(-1000, 0)
                                                                 forBarMetrics:UIBarMetricsDefault];
        }
        //设置导航返回按钮颜色
        self.navigationBar.tintColor = [UIColor whiteColor];
        //显示状态栏，设置状态栏颜色
        [UIApplication sharedApplication].statusBarStyle = UIStatusBarStyleLightContent;
        [[UIApplication sharedApplication] setStatusBarHidden:NO withAnimation:UIStatusBarAnimationFade];
    }
    return self;
}

@end
