//
//  YYAnalysisButton.m
//  YYObjCDemo
//
//  Created by zhaoxiangru on 2020/12/28.
//  Copyright © 2020 百度鹰眼. All rights reserved.
//

#import "YYAnalysisButton.h"

@implementation YYAnalysisButton

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        self.top = [[UIButton alloc] init];
        self.top.userInteractionEnabled = NO;
        self.bottom = [[UIButton alloc] init];
        self.bottom.userInteractionEnabled = NO;
        self.line = [[UIView alloc] init];
        [self.line setBackgroundColor:[UIColor blackColor]];
        [self addSubview:self.top];
        [self addSubview:self.bottom];
        [self addSubview:self.line];
        [self.top setTitle:@"0" forState:UIControlStateNormal];
        [self.top.titleLabel setFont:[UIFont boldSystemFontOfSize:26]];
        [self.top setTitleColor:[UIColor lightGrayColor] forState:UIControlStateNormal];
        
        [self.bottom.titleLabel setFont:[UIFont systemFontOfSize:18]];
        [self.bottom setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        [self.bottom setTitleColor:[UIColor blueColor] forState:UIControlStateSelected];
    }
    return self;
}

- (void)layoutSubviews {
    self.top.frame = CGRectMake(0, 0, self.frame.size.width, self.frame.size.height / 2.0);
    self.bottom.frame = CGRectMake(0, self.frame.size.height / 2.0, self.frame.size.width, self.frame.size.height / 2.0);
    self.line.frame = CGRectMake(0, self.frame.size.height / 5.0, 0.5, self.frame.size.height / 5.0 * 3);
}

- (void)setSelected:(BOOL)selected {
    [super setSelected:selected];
    self.top.selected = selected;
    self.bottom.selected = selected;
}
@end
