//
//  BTKAuthManager.h
//  BaiduTraceSDK
//
//  Created by zhangbaojin on 2023/1/5.
//  Copyright © 2023 Daniel Bey. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol BTKAuthDelegate;
@interface BTKAuthManager : NSObject

/// 获得实例对象
+ (instancetype)sharedInstance;

/// 进行鉴权。鉴权结果通过BTKAuthDelegate中的方法回调给开发者
/// @param key AK
/// @param delegate 回调对象
/// @return 参数错误则返回NO；鉴权请求发送成功则返回YES
- (BOOL)start:(NSString *)key generalDelegate:(nullable id <BTKAuthDelegate>)delegate;

@end

/// 鉴权通知Delegate
@protocol BTKAuthDelegate <NSObject>
@optional

/// 返回网络错误
/// @param iError 错误号
- (void)authOnGetNetworkState:(int)iError;

/// 返回授权验证错误
/// @param iError 错误号 : 为0时验证通过，具体参加BTKPermissionCheckResultCode
- (void)authOnGetPermissionState:(int)iError;

@end

NS_ASSUME_NONNULL_END
