//
//  BMKPOISearchOption.h
//  SearchComponent
//
//  Created by Baidu on 2018/5/8.
//  Copyright © 2018年 Baidu. All rights reserved.
//

#import "BMKGeocodeSearchOption.h"
#import "BMKGeocodeSearchResult.h"
#import "BMKSearchBase.h"

@protocol BMKGeoCodeSearchDelegate;
/// geo搜索服务
@interface BMKGeoCodeSearch : BMKSearchBase
/// geo检索模块的Delegate
@property (nonatomic, weak) id<BMKGeoCodeSearchDelegate> delegate;

/**
 *根据地址名称获取地理信息
 *异步函数，返回结果在BMKGeoCodeSearchDelegate的onGetAddrResult通知
 *@param geoCodeOption       geo检索信息类
 *@return 成功返回YES，否则返回NO
 */
- (BOOL)geoCode:(BMKGeoCodeSearchOption*)geoCodeOption;
/**
 *根据地理坐标获取地址信息
 *异步函数，返回结果在BMKGeoCodeSearchDelegate的onGetAddrResult通知
 *@param reverseGeoCodeOption 反geo检索信息类
 *@return 成功返回YES，否则返回NO
 */
- (BOOL)reverseGeoCode:(BMKReverseGeoCodeSearchOption*)reverseGeoCodeOption;
@end

///搜索delegate，用于获取搜索结果
@protocol BMKGeoCodeSearchDelegate<NSObject>
@optional
/**
 *返回地址信息搜索结果
 *@param searcher 搜索对象
 *@param result 搜索结果
 *@param error 错误号，@see BMKSearchErrorCode
 */
- (void)onGetGeoCodeResult:(BMKGeoCodeSearch *)searcher result:(BMKGeoCodeSearchResult *)result errorCode:(BMKSearchErrorCode)error;

/**
 *返回反地理编码搜索结果
 *@param searcher 搜索对象
 *@param result 搜索结果
 *@param error 错误号，@see BMKSearchErrorCode
 */
- (void)onGetReverseGeoCodeResult:(BMKGeoCodeSearch *)searcher result:(BMKReverseGeoCodeSearchResult *)result errorCode:(BMKSearchErrorCode)error;

@end




