//
//  AppDelegate.m
//  YYObjCDemo
//
//  Created by Daniel Bey on 2017年06月16日.
//  Copyright © 2017 百度鹰眼. All rights reserved.
//

#import "AppDelegate.h"
#import "YYMainViewController.h"
#import "YYNavigationViewController.h"

@implementation AppDelegate

#pragma mark - Application Lifecycle
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    // 加载DEMO的主页面
    YYMainViewController *rootVC = [[YYMainViewController alloc] init];
    YYNavigationViewController *navigationController = [[YYNavigationViewController alloc] initWithRootViewController:rootVC];
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    self.window.rootViewController = navigationController;
    [self.window makeKeyAndVisible];
    
    return YES;
}

-(void)applicationDidBecomeActive:(UIApplication *)application {
    // 每次进入应用时将角标清零
    [UIApplication sharedApplication].applicationIconBadgeNumber = 0;
}

#pragma mark - BMKGeneralDelegate
-(void)onGetNetworkState:(int)iError {
    if (0 == iError) {
        NSLog(@"联网成功");
    } else{
        NSLog(@"onGetNetworkState %d",iError);
    }
}

- (void)onGetPermissionState:(int)iError {
    if (0 == iError) {
        NSLog(@"授权成功");
    } else {
        NSLog(@"onGetPermissionState %d",iError);
    }
}

@end




