//
//  BTKPrivacyAuthorization.h
//  BaiduTraceSDK
//
//  Created by zhaoxiangru on 2022/3/9.
//  Copyright © 2022 Daniel Bey. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BTKPrivacyAuthorization : NSObject
/// 设置用户是否同意SDK隐私协议，默认不同意，since V3.1.5
/// 设置为YES时才能创建Action，否则返回nil，将影响鹰眼SDK所有功能的使用
/// 隐私政策官网链接：https://lbsyun.baidu.com/index.php?title=openprivacy
/// @param isAgree 用户是否同意SDK隐私协议
+(void)setAgreePrivacy:(BOOL)isAgree;
@end

NS_ASSUME_NONNULL_END
